# Routine IsStabilizable pour tester la stabilisabilité des systeme Nd
#restart;

# This procedure compute the number of complex roots on the unit complex circle
OnCircle:=proc(D,vars:=[op(indets(D))])
local f,p,q:
f:=numer(expand(subs({seq(v=(v-I)/(v+I),v in vars)},D))):
(p,q):=(expand(coeff(f,I,0)),expand(coeff(f,I,1))):
return nops(RootFinding:-Isolate(gcd(p,q),vars)); 
#degree(gcd(p,q));
end;

# This Procedure computes the inverse of a polynomial g modulo a polynomial f, i.e., it computes a polynomial U such that Ug+Vf=1. (f and g are supposed to be coprime)
Inverse:=proc(g::polynom,f::polynom)
local t:=0,r:=f, new_t :=1, new_r:=g,quotient,var;
var:=indets(g);
while degree(new_r)>0 do
quotient:= quo(r,new_r,op(var));
(t,new_t) := (new_t, expand(t-quotient*new_t)):
(r,new_r) := (new_r,expand(r-quotient*new_r)):
end do;
return primpart(new_t);
end proc;


# Procedure for computing from a RUR a univariate representation i.e. with coordinates given by polynomials (be carful, its substantially larger)
UnivR := proc(sys)
local RUR,g,UR,elem,var,i,coor,inv;
RUR:=Groebner[RationalUnivariateRepresentation](sys,t,output=polynomials);
inv:=Inverse(RUR[2],RUR[1],z);
UR:=[RUR[1]];
coor:=RUR[3];
for i from 1 to nops(coor) do
elem:= rhs(coor[i]);
g:=primpart(rem(inv*elem,RUR[1],t));
UR:=[op(UR),g];
end do;
return UR;
end proc;
# This procedure transformes a univariate polynomial into a system of two bivariate polynomial by decomposing its variable into real and imaginary part
Complextransform := proc(f::polynom)
local var,fbiv,h,s,a,b,sys;
var:=op(indets(f));
fbiv:=expand(subs(var=a+I*b,f));
h:=subs(I=s,fbiv);
sys:=[coeff(h,s,0),coeff(h,s,1)];
return sys;
end proc;

# Main procedure for testing the stabilizability
IsStabilizable := proc(sys)
local UR, RUR, OC,LS,i,sysbiv,vars,bivcoord,pol_circle,sign,sol,circle_sign,b,j,projection_pols,number_sol_circle, generic;
OC:=[];
vars:=indets(sys);
RUR:=Groebner[RationalUnivariateRepresentation](sys,t,output=polynomials):
projection_pols:=[seq(resultant(RUR[1],RUR[2]*lhs(RUR[3][i])-rhs(RUR[3][i]),t),i=1..nops(RUR[3]))];
number_sol_circle:=map(OnCircle,projection_pols);
generic:=true;
for i from 1 to nops(vars) do
if number_sol_circle[i]>0 then
generic:=false;
fi;
end do;
if (generic=true) then
#UR:=UnivR(sys);
sign:=[];
sol:=[fsolve(RUR[1],t,complex)];
#sol:=[fsolve(UR[1],t,complex)];
for i from 1 to nops(sol) do
sign:=[op(sign),map(a->subs(t=sol[i],rhs(a)/RUR[2]),RUR[3])];
#sign:=[op(sign),map(a->subs(t=sol[i],a),UR[2..-1])];
circle_sign:=map(a->map(a->abs(a),a),sign);
end do;
for i from 1 to nops(circle_sign) do
b:=false;
for j from 1 to nops(vars) do
 if circle_sign[i][j]>1 then
b:=true;
break;
fi;
end do;
if b=false then 
return false;
fi;
end do;
return true;
else
return "Il existe des coordonees sur le cercle unite";
fi;
end:
#sysbiv:=Complextransform(UR[1]);
#bivcoord:= Complextransform(UR[i+1]);
#pol_circle:=primpart(bivcoord[1]^2+bivcoord[2]^2-1);
#OC:= [op(OC),pol_circle];
#RootFinding[Isolate](sysbiv,[op(indets(sysbiv))],constraints=OC):


