read "IsStabilizable.mpl":
read "StabilizationZeroDim.mpl":


# Benchmark tools
# Parameters:
#   seconds - minimal number of seconds for the loop
#   iterations - minimal number of interations of the loop
#   f - the function to test
#   remaining arguments - passed to f for the tests
#
# Returns:
#   The average time spent to compute f on the remaining arguments, and a
#   list of the first iterations of the loop.
Timelaps := proc(seconds, iterations, f)
    local st, t, k, L, result;
    # For reproducible results
    RandomTools:-MersenneTwister:-SetState(state=123456789);
    st := time();
    t := time();
    k := 0;
    L := NULL;
    while t-st < seconds or k < iterations do
        result := f(_rest):
        if k < iterations then
            L := L, result
        end if;
        k := k+1;
        t := time();
    end do;
    
    return (t-st)/k, [L];
end proc;


# Actual benchmark
# 2D
TIsStabilizable2D := NULL;
TStabilization2D  := NULL;
Degrees := [[3,3], [5,5], [8,8], [10,10]];
for d in Degrees do
    print(`Stabilizable `, d);
    res := Timelaps(5,1,IsStabilizable@GenerateDenseSystem,d,x,scale=10);
    TIsStabilizable2D := TIsStabilizable2D, [d,[res][1]];
    save(TIsStabilizable2D,TStabilization2D,"results.mpl");
    print(`Stabilization `, d);
    res := Timelaps(5,1,StabilizingPolynomial@GenerateDenseSystem,d,x,scale=10);
    TStabilization2D := TStabilization2D, [d,[res][1]];
    save(TIsStabilizable2D,TStabilization2D,"results.mpl");
end do:

# 3D
TIsStabilizable3D := NULL;
TStabilization3D  := NULL;
Degrees := [[2,2,2], [3,3,3], [3,3,4], [3,4,4], [4,4,4]];
for d in Degrees do
    print(`Stabilizable `, d);
    res := Timelaps(5,1,IsStabilizable@GenerateDenseSystem,d,x,scale=10);
    TIsStabilizable3D := TIsStabilizable3D, [d,[res][1]];
    save(TIsStabilizable2D,TStabilization2D,
         TIsStabilizable3D,TStabilization3D,"results.mpl");
    print(`Stabilization `, d);
    res := Timelaps(5,1,StabilizingPolynomial@GenerateDenseSystem,d,x,scale=10);
    TStabilization3D := TStabilization3D, [d,[res][1]];
    save(TIsStabilizable2D,TStabilization2D,
         TIsStabilizable3D,TStabilization3D,"results.mpl");
end do:


