read "StabilizationZeroDim.mpl":
infolevel[StabilizingPolynomial] := 1;
Digits := 100;

###### Generation of polynomial interpolated from random points ######

# Handcrafted system

L := [ [1-sqrt(3),1+sqrt(3)], [1+sqrt(3),1-sqrt(3)] ];
sys := map(expand@numer@normal, InterpolateSystem(L, x));
f, d, N := Groebner:-RationalUnivariateRepresentation(sys, v,
                                                      output = polynomials):
N := PolynomialUnivariateRepresentation(f, d, N, v):
d := 1:
S := SeparatingForm(f, d, N, v);
prec := 1;
V := SolveCertified(f, prec);
F := VanishingPolynomials(V, f, d, N, S, v);
ftilde := mul(v-a, a in V);
stilde := mul(f, f in F);
stildet := subs(N, stilde);
h0 := quo(stildet, ftilde, v);
s  := eval(stilde + h0*(f-ftilde), v=x[1]);
p   := StabilizingPolynomial(sys,precision=2,linear);

Solutions := plots:-pointplot(L, symbol=diamond, legend="Solutions"):
Sinfinity := plots:-implicitplot((x[1]-1-sqrt(3))*(x[2]-1-sqrt(3)),
                                 x[1]=-5..5, x[2]=-5..5, gridrefine=3,
                                 linestyle=dot, legend="Exact factorization"):
S1 := plots:-implicitplot(stilde, x[1]=-5..5, x[2]=-5..5, gridrefine=3,
                                 linestyle=dash,
                                 legend="Approximate factorization"):
P := plots:-implicitplot(p, x[1]=-5..5, x[2]=-5..5, gridrefine=3,
                                 legend="Stable curve"):
#interface(plotdevice=png):
plotsetup(ps, plotoutput = "example.ps"):
plots:-display([Solutions,Sinfinity,S1,P], axes=boxed, view=[-5..5, -5..5]);
#plotsetup(ps, plotoutput = "approximate.ps"):
#plots:-display([Solutions,S1], axes=boxed, view=[-5..5, -5..5]);
#plotsetup(ps, plotoutput = "snapped.ps"):
#plots:-display([Solutions,P], axes=boxed, view=[-5..5, -5..5]);
#plots:-implicitplot(p, x[1]=-5..5, x[2]=-5..5, gridrefine=3, axes=boxed, view=[-5..5, -5..5]);
