mycoeff:=proc(F,x,y,i,j,x0,y0,L)
# Returns the coeff of F in (x-x0)^j*(y-y0)^i
# x0 and h0 might be polynomials in x (and y)
    coeftayl(evala(expand(eval(`if`(i=0,F,diff(F,y$i)),{x=x0,y=eval(y0,y=0)})*eval(coeff(y0,y),x=1)^i)),h=0,j+L-i*degree(coeff(y0,y)+1,x))/i!;
end;

myldegree:=proc(f,x)
# returns the ldegree of f in x (f might not be a polynom, but has
# only one variable)
local j;
    if f=0 then return infinity fi;
    j:=0;
    while evala(coeftayl(f,x=0,j)) = 0 do
        j:=j+1
    od;
    return j
end:

polygon:=proc(F,x,y,M,L,x0,y0)
# It computes the newton polygon associated to the polynom F(x,y).
local a,ii,i,good,j,k;
    ii:=[seq(myldegree(simplify(evala(expand(eval(`if`(i=0,F,diff(F,y$i)),{x=x0,y=eval(y0,y=0)})))),x)+degree(coeff(y0,y)+1,x)*i-L,i=0..M)];# le +1 au coeff pour obtenir 0 si pas de y dans y0
    a:=[seq([i-1,ii[i]],i=1..M+1)];
    good:=[seq(true,i=1..nops(a))];
    for i from 2 to nops(a)-1 do
        for j to i-1 do
            for k from i+1 to nops(a) do
                if a[i][2]>=(a[j][2]-a[k][2])/(a[j][1]-a[k][1])*(a[i][1]-a[k][1])+a[k][2] then
                    good[i]:=false;
                    break;
                fi;
            od;
            if not(good[i]) then break; fi;
        od;
    od;
    [seq(`if`(good[i],a[i],NULL),i=1..nops(a))];
end:

pts:=proc(G,x,y,T,a,b,x0,y0,L)
# It computes m,q,l,phi,u,v for one vertex Delta=[a,b]
local ptI,ptJ,i,j,m,q,u,v,l,phi,alpha;
    ptI,ptJ,i,j:=`if`(a[1]<b[1],op([op(a),op(b)]),op([op(b),op(a)]));
    m,q:=-numer((ptJ-j)/(ptI-i)),denom((ptJ-j)/(ptI-i));
    igcdex(q,m,'u','v');
    u,v:=u,-v;
    while v < 0 do u,v:=u+m,v+q od;
    while v >= q do u,v:=u-m,v-q od;
    l:=m*ptI+q*ptJ;
    phi:=add(mycoeff(G,x,y,alpha,(l-m*alpha)/q,x0,y0,L)*T^((alpha-ptI)/q),alpha in [seq(beta,beta=ptI..i,q)]);#
    m,q,l,u,v,phi;
end:

myRoots:=proc(phi,alpha)
    factors(phi)[2];
end;


numIpuiseux:=proc(F,x,y,x0,y0)
local rpe,t,res;
    userinfo(3,'Ipui',`Starting`);
    t:=time():
    rpe:=Ipuiseux(args);
    res:=RPE2numCPS(rpe,x);
    userinfo(3,'Ipui',`Done in`,time()-t);
    res
end:

Ipuiseux:=proc(F,x,y,x0,y0)
# on va dire qu'on part sans extension ; cette partie est mal gérée pour le moment
    local M,res;
    M:=myldegree(simplify(evala(expand(eval(F,{x=x0,y=y0+y})))),y);
    res:=Inewton(F,x,y,M,x0+x,y0+y,0,[]);
#    lprint(res);
    eval(res,y=0);
end:

Inewton:=proc(F,x,y,M,x0,y0,L,ext)
# Remark: the case where Y divides F is not yet implemented.
# L le correctif (correspondant a la division par x normalement faite)
local res,a,i,Delta,m,q,l,phi,Z,xi,G,j,u,v,isIm,tmp,r;
    userinfo(4,'Ipui',`In Inewton ; evaluation point is`,x0,y0);
    userinfo(4,'Ipui',`In Inewton ; correctign term is`,L);
    a:=polygon(F,x,y,M,L,x0,y0);
    userinfo(4,'Ipui',`Newton polygon is`,a);
    res:=NULL;
    for i to nops(a)-1 do
        Delta:=a[i..i+1];
# Delta is the edge of the newtonpolygon we are looking for.
        m,q,l,u,v,phi:=pts(F,x,y,Z,op(Delta),x0,y0,L);
        userinfo(4,'Ipui',`Edge`,i,`m,q,l,u,v,phi is`,m,q,l,u,v,phi);
# m,q and l represent the edge Delta.
# phi is the characteristic polynomial asociated to Delta.
        for j in myRoots(phi,ext) do
            # racine qui nous interessent : x^2+alpha, alpha > 0 ;
            # x<0, q=2 ; x>0, q=4 ; x^2 < 0 (en cas de RootOf)
            # sinon, pas d'appel recursif
            userinfo(4,'Ipui',`Dealing with root`,j);
            xi:=RootOf(j[1]);
            userinfo(4,'Ipui',`xi is`,xi);
            tmp:=[eval(x0,x=xi^v*x^q),expand(eval(y0,{x=xi^v*x^q,y=x^m*(y+xi^u)})),j[2]];
            userinfo(3,'Ipui',`current RNP is`,tmp);
            r:=degree(coeff(tmp[2],y,1),x);
            if isCoeffIR(tmp[1],x,coeff(eval(tmp[2],y=0),x,r),r) then
                userinfo(3,'Ipui',`Going for a recursive call`);
                userinfo(3,'Ipui',`Correcting L is`,q*L+l);
                for tmp in Inewton(F,x,y,tmp[3],op(tmp[1..2]),q*L+l,ext) do # p.63 these pour checker les bonnes formules.
                    res:=res,tmp;
                od;
            else
                userinfo(3,'Ipui',`We're done`);
                res:=res,tmp;
            fi
        od;
    od;
    [res]
end:

isCoeffIR:=proc(xT,T,c,m)
# xT=x0+lambda*T^e ; c a coefficient, m and exponent
# Returns true iff there is a t s.t. t^e=1/lambda and Re(t^m*c)=0
local sols,t,e,lambda,i;
    e:=degree(xT,T);
    lambda:=coeff(xT,T,e);
    sols:=[solve(t^e=1/lambda)];
    for i in sols do
        userinfo(4,'Ipui',`real part is`,Re(c*i^m));
        userinfo(4,'Ipui',`real part is approximately`,evalf(Re(c*i^m)));
        if (Re(c*i^m)=0) then
            return true
        fi
    od:
    return false;
end:

RPE2numCPS:=proc(rpe,T)
local res,e,alpha,sol,t,pui,t0;
    res:=NULL;
    for pui in rpe do
        e:=degree(pui[1],T):
        alpha:=coeff(pui[1],T,e):
        t0:=coeff(pui[1],T,0):
        userinfo(4,'Ipui',`e,alpha are`,e,alpha);
        for sol in [fsolve(t^e=1/alpha,t,'complex')] do
            res:=res,eval([collect(evalf[12](eval(pui[2],T=sol*T^(1/e))),T),pui[3]],T=T-t0)
        od
    od;       
#    eval(rpe[2],{y=0,x=((x-coeff(rpe[1],x,0))/coeff(rpe[1],x,degree(rpe[1],x)))^(1/degree(rpe[1],x))})
    [res];
end;
