with(combinat):
with(RootFinding):

TransformationMoebius:=proc(D,vars:=[op(indets(D))])
local f:
f:=numer(expand(subs({seq(v=(v-I)/(v+I),v in vars)},D))):
return([expand(coeff(f,I,0))=0,expand(coeff(f,I,1))=0]):
end:

BistritzTest:=proc(D::polynom,var:=op(indets(D)))
local i,rD,n,T,TT,cst,a,Temp;
n:=degree(D);
if subs(var=1,D)=0 then
return false;
end if;
rD:=expand(var^n*subs(var=1/var,D));
T:=D+rD;
a:=subs(var=1,T);
TT:=simplify(expand((D-rD)/(var-1)));
for i from 0 to (n-1) do
if (subs(var=0,TT)=0 or a*subs(var=1,TT)<=0) then
return false;
end if;
cst:=subs(var=0,T)/subs(var=0,TT);
Temp:=TT;
TT:=simplify(expand((cst*(1+var)*TT-T)/var));
T:=Temp;
end do;
return true;
end proc:


IsStable := proc(D::polynom)
local sys,f,vars,i,j,k,L,b,h,fconjugate,sys2,sys1,vars2,var;
b:=true;
vars:=indets(D);
for i from 0 to nops(vars)-1 do
L:={seq(subs(seq(vars[k[j]]=1, j=1..i),D),k in {op(choose(nops(vars),i))})};
## Univariate stability test
if i=nops(vars)-1 then
for f in L do
var:=op(indets(f));
if subs(var=0,f)=0 then
return false;
end if;
h:=numer(subs(var=1/var,f));
if evalb(BistritzTest(h))=false then
return false;
end if;
end do;
else
## Intersection with the poly-circle
for f in L do
vars2:=indets(f);
sys:=TransformationMoebius(f);
##fconjugate:=numer(expand(subs({seq(v=1/v,v in vars)},f))):
##sys2:=TransformationMoebius(fconjugate);
##sys:=[op(sys1),op(sys2)];
if evalb(HasRealRoots(sys,indets(sys)))=true then
#HasRealSolutions(op(sys),[op(indets(sys))]):
b:=false;
end if;
end do;
end if;
end do;
return b;
end proc:

IsStableVar := proc(D::polynom,method)
local sys,f,vars,i,j,k,L,b,h,fconjugate,sys2,sys1,vars2,var,R,u;
b:=true;
vars:=indets(D);
for i from 0 to nops(vars)-1 do
L:={seq(subs(seq(vars[k[j]]=1, j=1..i),D),k in {op(choose(nops(vars),i))})};
## Univariate stability test
if i=nops(vars)-1 then
for f in L do
var:=op(indets(f));
if subs(var=0,f)=0 then
return false;
end if;
h:=numer(subs(var=1/var,f));
if evalb(BistritzTest(h))=false then
return false;
end if;
end do;
else
## Intersection with the poly-circle
for f in L do
vars2:=indets(f);
sys:=TransformationMoebius(f);
#return sys;
##fconjugate:=numer(expand(subs({seq(v=1/v,v in vars)},f))):
##sys2:=TransformationMoebius(fconjugate);
##sys:=[op(sys1),op(sys2)];
#if evalb(HasRealRoots(sys,indets(sys)))=true then
if _params['method']='CRIT' then
HasRealSolutions(sys,[op(indets(sys))]):
else
R:=PolynomialRing([op(indets(sys))]):
u:=CylindricalAlgebraicDecompose([sys],R):
end if;
#b:=false;
#end if;
end do;
end if;
end do;
#return u;
end proc:

IsStablefactor := proc(D::polynom)
local facts,liststable,list;
facts := factors(D);
list:=map(a->a[1],facts[2]);
liststable:= map(a->IsStable(a),list);
return not(has(liststable,false));
end proc:
