
# Transformes the equation D(x,y)=0 to a system of equation [R(x,y)=C(x,y)=0] applying a Mobius transform

TransformationMoebius:=proc(D,vars:=[op(indets(D))])
local f:
f:=numer(expand(subs({seq(v=(v-I)/(v+I),v in vars)},D))):
return ([expand(coeff(f,I,0)),expand(coeff(f,I,1))]):
end:


# Generate systems with parameters with degree in tha variable<2d
# degree d, term_density in [0..100], bit_size t, coeff are 2^t, number of parameters nbparam , degree in the parameters dparam 
generate_systems_param := proc(d,term_density,bitsize,nbparam,dparam)
local max_coeff, nb_terms,D, L, Lparam,Lcoeff,u;
max_coeff:=2^bitsize:
nb_terms:=round((term_density/100)*((d+1)*(d+2)/2)):
Lparam:=seq(cat(u,i),i=1..nbparam):
D:=randpoly([x,y],terms=nb_terms,degree=d,coeffs=proc() randpoly([Lparam],degree=dparam,coeffs=rand(-max_coeff..max_coeff)) end proc):
L:=TransformationMoebius(D,[x,y]):
return L,D:
end:
generate_systems_param(4,30,4,2,4):
sys,Pol:=generate_systems_param(3,50,2,2,1):
sys;
Pol;
# bel exemple (4*u1+2*u2+3)*x+(-2*u1+1)*y+(4*u1-2*u2-2)*x*y+(2*u1-2*u2+4)*x^2*y+(-u1-u2+1)*x*y^2
BistritzTest:=proc(D::polynom,var:=op(indets(D)))
local i,rD,n,T,TT,cst,a,Temp;
n:=degree(D);
if subs(var=1,D)=0 then
return false;
end if;
rD:=expand(var^n*subs(var=1/var,D));
T:=D+rD;
a:=subs(var=1,T);
TT:=simplify(expand((D-rD)/(var-1)));
for i from 0 to (n-1) do
if (subs(var=0,TT)=0 or a*subs(var=1,TT)<=0) then
return false;
end if;
cst:=subs(var=0,T)/subs(var=0,TT);
Temp:=TT;
TT:=simplify(expand((cst*(1+var)*TT-T)/var));
T:=Temp;
end do;
return true;
end proc:
BPR_STAB_COND:=proc(Pol,v,params)
   local z,D1,DisVar1,uu,F1,G1,sres,R:
   D1:=numer(subs(v=1-v/(v+1),Pol));
   DisVar1:=[coeffs(D1,v)];
   uu:=algsubs(v^2=z,D1);
   F1:=coeff(uu,v,0);
   G1:=coeff(uu,v,1):
   R := RegularChains[PolynomialRing]([op(params),z]);
   if (degree(D1,vars[1]) mod 2 =0) then
      sres:=RegularChains[ChainTools][SubresultantChain] (F1, G1, z, R,representation = 'MonomialBasis');   
   else
      sres:=RegularChains[ChainTools][SubresultantChain] (z*G1, F1, z, R,representation = 'MonomialBasis');
   fi:
   DisVar1:=remove(uu->uu=0,[op(DisVar1),op(map(uu->lcoeff(uu,z),sres[subresultant_chain_vector]))]);
end:
   
DisVary:=[op(BPR_STAB_COND(subs(x=1,Pol),y,[u1,u2])),op(BPR_STAB_COND(subs(y=1,Pol),x,[u1,u2]))];
m:=RootFinding[Parametric][CellDecomposition]([op(map(uu->uu=0,sys)),op(map(uu->uu>0,DisVary))],[x,y]);
RootFinding[Parametric][CellPlot](m,samplepoints=false);
RootFinding[Parametric][CellPlot](m,samplepoints=false,view=[-4..2,-7..7]);
RootFinding[Parametric][CellPlot](m,samplepoints=false,view=[-0.4..-0.6,-0.4..-0.6]);
rr:=RootFinding[Parametric][NumberOfSolutions](m);
ss:=select(uu->uu[2]<>0,rr);
nops(rr);
nops(ss);
m[SamplePoints][333];
evalf(%);
m[SamplePoints][332];
evalf(%);
m[SamplePoints][334];
evalf(%);

